/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.utils.Pools;

public class StageAreaOnlyInputHandler
implements InputProcessor {
    private final Stage parent;

    public StageAreaOnlyInputHandler(Stage parent) {
        this.parent = parent;
    }

    @Override
    public boolean keyDown(int keycode) {
        return this.parent.keyDown(keycode);
    }

    @Override
    public boolean keyUp(int keycode) {
        return this.parent.keyUp(keycode);
    }

    @Override
    public boolean keyTyped(char character) {
        return this.parent.keyTyped(character);
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return this.parent.touchDown(screenX, screenY, pointer, button);
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return this.parent.touchUp(screenX, screenY, pointer, button);
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return this.parent.touchDragged(screenX, screenY, pointer);
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        Vector2 mouseStageCoords = this.parent.screenToStageCoordinates(new Vector2(Gdx.input.getX(), Gdx.input.getY()));
        Actor target = this.parent.hit(mouseStageCoords.x, mouseStageCoords.y, true);
        if (target == null) {
            return false;
        }
        this.parent.mouseMoved(screenX, screenY);
        return true;
    }

    @Override
    public boolean scrolled(int amount) {
        Vector2 mouseStageCoords = this.parent.screenToStageCoordinates(new Vector2(Gdx.input.getX(), Gdx.input.getY()));
        Actor target = this.parent.hit(mouseStageCoords.x, mouseStageCoords.y, true);
        if ((target = this.findParentScrollable(target)) == null) {
            target = this.parent.getRoot();
        }
        if (target.getX() <= mouseStageCoords.x && mouseStageCoords.x <= target.getX() + target.getWidth() && target.getY() <= mouseStageCoords.y && mouseStageCoords.y <= target.getY() + target.getHeight()) {
            InputEvent event = Pools.obtain(InputEvent.class);
            event.setStage(this.parent);
            event.setType(InputEvent.Type.scrolled);
            event.setScrollAmount(amount);
            event.setStageX(mouseStageCoords.x);
            event.setStageY(mouseStageCoords.y);
            target.fire(event);
            boolean handled = event.isHandled();
            Pools.free(event);
            return handled;
        }
        return false;
    }

    private Actor findParentScrollable(Actor actor) {
        if (actor == null) {
            return null;
        }
        if (actor instanceof ScrollPane) {
            return actor;
        }
        return this.findParentScrollable(actor.getParent());
    }
}

